﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace DrzewoKatalogow
{
    public partial class Form1 : Form
    {
        bool uwzglednijPliki = true;

        public Form1()
        {
            InitializeComponent();

            UtworzDrzewoKatalogow(treeView1, uwzglednijPliki);
        }

        public void UtworzDrzewoKatalogow(TreeView treeView, bool uwzglednijPliki)
        {            
            treeView.BeginUpdate();
            treeView.Nodes.Clear();
            TreeNode wezelGlowny = new TreeNode("Moje urządzenie");
            wezelGlowny.Tag = @"\";
            DodajKatalogDoWezla(@"\", wezelGlowny, uwzglednijPliki, 0, 2);
            treeView.Nodes.Add(wezelGlowny);
            wezelGlowny.Expand();
            treeView.EndUpdate();            
        }

        private void DodajKatalogDoWezla(string sciezka, TreeNode wezel, bool uwzglednijPliki, int poziom, int maksymalnyPoziom)
        {
            poziom++;
            if (maksymalnyPoziom>0 && poziom > maksymalnyPoziom) return;

            //katalogi
            try
            {
                string[] foldery = Directory.GetDirectories(sciezka);
                foreach (string folder in foldery)
                {
                    TreeNode nowyWezel = new TreeNode("[" + Path.GetFileName(folder) + "]");
                    nowyWezel.Tag = folder;
                    //nowyWezel.ForeColor = Color.Black;
                    DodajKatalogDoWezla((string)nowyWezel.Tag, nowyWezel, uwzglednijPliki, poziom, maksymalnyPoziom);
                    wezel.Nodes.Add(nowyWezel);
                }
            }
            catch { }

            if (uwzglednijPliki)
            {
                //pliki
                try
                {
                    string[] pliki = Directory.GetFiles(sciezka);
                    foreach (string plik in pliki)
                    {
                        TreeNode nowyWezel = new TreeNode(Path.GetFileName(plik));
                        nowyWezel.Tag = plik;
                        //nowyWezel.ForeColor = Color.Navy;
                        wezel.Nodes.Add(nowyWezel);
                    }
                }
                catch { }
            }
        }        

        private void menuItem2_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void treeView1_AfterSelect(object sender, TreeViewEventArgs e)
        {
            TreeNode wezel = e.Node;
            string sciezka = (string)wezel.Tag;
            //statusBar1.Text = (string)wezel.Tag;

            //Lewy element menu
            menuItem1.Text = "Otwórz";

            if (wezel.GetNodeCount(false) > 0)
            {
                if (wezel.IsExpanded) menuItem1.Text = "Zwiń";
                else menuItem1.Text = "Rozwiń";
            }
            else
            {
                menuItem1.Text = "";
            }

            //Opis w pasku stanu
            //plik
            if (File.Exists(sciezka))
            {
                FileInfo fi = new FileInfo(sciezka);
                string nazwaPliku = fi.FullName;
                const int dlg = 20;
                if (nazwaPliku.Length > dlg + 3) nazwaPliku = "..." + nazwaPliku.Substring(nazwaPliku.Length - dlg, dlg);
                long wielkoscPliku = fi.Length;
                string jednostka = "B";
                if (wielkoscPliku > 10240)
                {
                    wielkoscPliku /= 1024;
                    jednostka = "kB";
                }
                if (wielkoscPliku > 10240)
                {
                    wielkoscPliku /= 1024;
                    jednostka = "MB";
                }
                if (wielkoscPliku > 10240)
                {
                    wielkoscPliku /= 1024;
                    jednostka = "GB";
                }
                statusBar1.Text = "Plik: " + nazwaPliku + " (" + wielkoscPliku + " " + jednostka + ")";
                menuItem1.Text = "Otwórz";
                if (fi.Extension == ".exe") menuItem1.Text = "Uruchom";
            }
            //katalog
            if (Directory.Exists(sciezka))
            {
                DirectoryInfo di = new DirectoryInfo(sciezka);
                string nazwaKatalogu = di.FullName;
                const int dlg = 25;
                if (nazwaKatalogu.Length > dlg + 3) nazwaKatalogu = "..." + nazwaKatalogu.Substring(nazwaKatalogu.Length - dlg, dlg);
                statusBar1.Text = "Katalog: " + nazwaKatalogu;
            }

            menuItem1.Enabled = (menuItem1.Text != "");
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            TreeNode wezel = treeView1.SelectedNode;
            string sciezka = (string)wezel.Tag;
            
            if (File.Exists(sciezka))
            {
                try
                {
                    System.Diagnostics.Process.Start(sciezka, "");
                }
                catch
                {
                    MessageBox.Show("Nie udało się otworzyć pliku!", "Błąd!");
                }
            }
            else
            {
                if (!wezel.IsExpanded) wezel.Expand();
                else wezel.Collapse();
            }
            
            treeView1_AfterSelect(treeView1,new TreeViewEventArgs(wezel,TreeViewAction.Unknown));
        }

        private void treeView1_BeforeExpand(object sender, TreeViewCancelEventArgs e)
        {
            //if(e.Action!=TreeViewAction.Expand) return;
            TreeNode wezel = e.Node;
            wezel.TreeView.BeginUpdate();
            //foreach (TreeNode w in wezel.Nodes) w.Remove();
            for (int i = wezel.Nodes.Count - 1; i >= 0; --i) wezel.Nodes.RemoveAt(i);
            DodajKatalogDoWezla((string)wezel.Tag, wezel, uwzglednijPliki, 0, 2);
            wezel.TreeView.EndUpdate();
        }
    }
}